unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    Load: TButton;
    OpenDialog1: TOpenDialog;
    Save: TButton;
    Memo1: TMemo;
    SaveDialog1: TSaveDialog;
    procedure LoadClick(Sender: TObject);
    procedure SaveClick(Sender: TObject);
   private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }

procedure TForm1.SaveClick(Sender: TObject);
var
  tfile: TStringList;
  str: string;
  fname: string;
begin
  tfile:= TStringList.Create;
  str:= Memo1.Text;
  {$IFDEF WINDOWS}
    str:= UTF8ToSys(str); // преобразование в системную кодировку
  {$ENDIF}
  tfile.Add(str);
  SaveDialog1.FileName:= fname;
  if SaveDialog1.Execute
  then fname:= SaveDialog1.FileName;
  fname:= UTF8ToSys(fname); // преобразование в системную кодировку
  tfile.SaveToFile(fname);
  tfile.Free;
end;

procedure TForm1.LoadClick(Sender: TObject);
var
  tfile: TStringList;
  str: string;
  fname: string;
begin
  Memo1.Clear;
  tfile:= TStringList.Create;
  if OpenDialog1.Execute
  then fname:= OpenDialog1.FileName;
  fname:= UTF8ToSys(fname);   // преобразование в системную кодировку
  tfile.LoadFromFile(fname);
  str:= tfile.Text;
  {$IFDEF WINDOWS}
    str:= SysToUTF8(str); // преобразование в кодировку UTF-8
  {$ENDIF}
  Memo1.Lines.Add(str);
  tfile.Free;
  Memo1.SetFocus;
  Memo1.SelStart:= 0;
end;

initialization
  {$I unit1.lrs}

end.

